<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductIdentifierType extends Model 
{

    protected $table = 'products_identifiers_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function products_identifiers()
    {
        return $this->hasMany('App\Models\Product\ProductIdentifier', 'product_identifier_type_id');
    }

    public function person()
    {
        return $this->belongsTo('App\Models\Person\Person', 'person_id');
    }

}